<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Models\Amphur;
use App\Http\Models\Province;
use Illuminate\Http\Request;
use Exception;

class AmphursController extends Controller
{

    /**
     * Display a listing of the amphurs.
     *
     * @return Illuminate\View\View
     */
    public function index()
    {
        $amphurs = Amphur::with('province')->paginate(25);

        return view('amphurs.index', compact('amphurs'));
    }

    /**
     * Show the form for creating a new amphur.
     *
     * @return Illuminate\View\View
     */
    public function create()
    {
        $provinces = Province::pluck('name','id')->all();
        
        return view('amphurs.create', compact('provinces'));
    }

    /**
     * Store a new amphur in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        try {
            
            $data = $this->getData($request);
            
            Amphur::create($data);

            return redirect()->route('amphurs.amphur.index')
                ->with('success_message', 'เพิ่ม Amphur ใหม่แล้ว');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }
    }

    /**
     * Display the specified amphur.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function show($id)
    {
        $amphur = Amphur::with('province')->findOrFail($id);

        return view('amphurs.show', compact('amphur'));
    }

    /**
     * Show the form for editing the specified amphur.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        $amphur = Amphur::findOrFail($id);
        $provinces = Province::pluck('name','id')->all();

        return view('amphurs.edit', compact('amphur','provinces'));
    }

    /**
     * Update the specified amphur in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        try {
            
            $data = $this->getData($request);
            
            $amphur = Amphur::findOrFail($id);
            $amphur->update($data);

            return redirect()->route('amphurs.amphur.index')
                ->with('success_message', 'ปรับปรุงข้อมูล Amphur เรียบร้อยแล้วค่ะ');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }        
    }

    /**
     * Remove the specified amphur from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        try {
            $amphur = Amphur::findOrFail($id);
            $amphur->delete();

            return redirect()->route('amphurs.amphur.index')
                ->with('success_message', 'ลบข้อมูล Amphur เรียบร้อยแล้วค่ะ');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }
    }

    
    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request 
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
                'provinces_id' => 'required',
            'name_th' => 'nullable|string|min:0|max:50',
            'name_en' => 'nullable|string|min:0|max:50',
            'size' => 'nullable', 
        ];
        
        $data = $request->validate($rules);


        return $data;
    }

}
