<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Models\Associate;
use Illuminate\Http\Request;
use Exception;

class AssociatesController extends Controller
{

    /**
     * Display a listing of the associates.
     *
     * @return Illuminate\View\View
     */
    public function index()
    {
        $associates = Associate::paginate(25);

        return view('associates.index', compact('associates'));
    }

    /**
     * Show the form for creating a new associate.
     *
     * @return Illuminate\View\View
     */
    public function create()
    {
        
        
        return view('associates.create');
    }

    /**
     * Store a new associate in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        try {
            
            $data = $this->getData($request);
            
            Associate::create($data);

            return redirect()->route('associates.associate.index')
                ->with('success_message', 'เพิ่ม Associate ใหม่แล้ว');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }
    }

    /**
     * Display the specified associate.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function show($id)
    {
        $associate = Associate::findOrFail($id);

        return view('associates.show', compact('associate'));
    }

    /**
     * Show the form for editing the specified associate.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        $associate = Associate::findOrFail($id);
        

        return view('associates.edit', compact('associate'));
    }

    /**
     * Update the specified associate in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        try {
            
            $data = $this->getData($request);
            
            $associate = Associate::findOrFail($id);
            $associate->update($data);

            return redirect()->route('associates.associate.index')
                ->with('success_message', 'ปรับปรุงข้อมูล Associate เรียบร้อยแล้วค่ะ');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }        
    }

    /**
     * Remove the specified associate from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        try {
            $associate = Associate::findOrFail($id);
            $associate->delete();

            return redirect()->route('associates.associate.index')
                ->with('success_message', 'ลบข้อมูล Associate เรียบร้อยแล้วค่ะ');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }
    }

    
    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request 
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
                'name' => 'required|string|min:1|max:45', 
        ];
        
        $data = $request->validate($rules);


        return $data;
    }

}
