<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request; 
use Illuminate\Support\Facades\Session;
use Auth;
class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

public function login (Request $request)
	 {
		 
			$username =trim( $request->username); //the input field has name='username' in form
			$password =trim (  $request->password); //the input field has name='password' in form
		 #@	dd($password . $username);
		if(filter_var($username, FILTER_VALIDATE_EMAIL)) {
			//user sent their email 
			Auth::attempt(['email' => $username, 'password' => $password ]);
		} else {
		//they sent their username instead 
			if(Auth::attempt(['username' => $username, 'password' => $password ])==true){
			}  
		}
	 $device= "" ;
	 if($request->header('User-Agent'))
	 if(preg_match( "/Windows|NT/",$request->header('User-Agent'))==1)
	 {
		 $device = "PC";
	 }
	  if(preg_match( "/iPhone|iPad/",$request->header('User-Agent'))==1)
	 {
		 $device = "iPhone|iPad";
	 }
	 
	  if(preg_match( "/Linux|Android/",$request->header('User-Agent'))==1)
	 {
		 $device = "Android Mobile";
	 }
		//was any of those correct ?
		if ( Auth::check() ) {
			//send them where they are going 
			
			
			 
			return redirect()->intended('/home');
		}
	
		//Nope, something wrong during authentication 
	 
		return redirect()->back()->withInput()->withErrors([
			'credentials' => 'ลงชื่อเข้าใช้งานไม่สำเร็จค่ะ กรุณาตรวจสอบ ชื่อผู้ใช้งานระบบและรหัสผ่าน ของท่านอีกครั้งค่ะ'
		]);
	}
}