<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Models\Education;
use Illuminate\Http\Request;
use Exception;

class EducationsController extends Controller
{

    /**
     * Display a listing of the educations.
     *
     * @return Illuminate\View\View
     */
    public function index()
    {
        $educations = Education::paginate(25);

        return view('educations.index', compact('educations'));
    }

    /**
     * Show the form for creating a new education.
     *
     * @return Illuminate\View\View
     */
    public function create()
    {
        
        
        return view('educations.create');
    }

    /**
     * Store a new education in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        try {
            
            $data = $this->getData($request);
            
            Education::create($data);

            return redirect()->route('educations.education.index')
                ->with('success_message', 'เพิ่ม Education ใหม่แล้ว');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }
    }

    /**
     * Display the specified education.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function show($id)
    {
        $education = Education::findOrFail($id);

        return view('educations.show', compact('education'));
    }

    /**
     * Show the form for editing the specified education.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        $education = Education::findOrFail($id);
        

        return view('educations.edit', compact('education'));
    }

    /**
     * Update the specified education in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        try {
            
            $data = $this->getData($request);
            
            $education = Education::findOrFail($id);
            $education->update($data);

            return redirect()->route('educations.education.index')
                ->with('success_message', 'ปรับปรุงข้อมูล Education เรียบร้อยแล้วค่ะ');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }        
    }

    /**
     * Remove the specified education from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        try {
            $education = Education::findOrFail($id);
            $education->delete();

            return redirect()->route('educations.education.index')
                ->with('success_message', 'ลบข้อมูล Education เรียบร้อยแล้วค่ะ');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }
    }

    
    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request 
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
                'name' => 'nullable|string|min:0|max:50', 
        ];
        
        $data = $request->validate($rules);


        return $data;
    }

}
