<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Models\Electorate;
use Illuminate\Http\Request;
use Exception;

class ElectoratesController extends Controller
{

    /**
     * Display a listing of the electorates.
     *
     * @return Illuminate\View\View
     */
    public function index()
    {
        $electorates = Electorate::paginate(25);

        return view('electorates.index', compact('electorates'));
    }

    /**
     * Show the form for creating a new electorate.
     *
     * @return Illuminate\View\View
     */
    public function create()
    {
        
        
        return view('electorates.create');
    }

    /**
     * Store a new electorate in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        try {
            
            $data = $this->getData($request);
            
            Electorate::create($data);

            return redirect()->route('electorates.electorate.index')
                ->with('success_message', 'เพิ่ม เขตเลือกตั้ง ใหม่แล้ว');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }
    }

    /**
     * Display the specified electorate.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function show($id)
    {
        $electorate = Electorate::findOrFail($id);

        return view('electorates.show', compact('electorate'));
    }

    /**
     * Show the form for editing the specified electorate.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        $electorate = Electorate::findOrFail($id);
        

        return view('electorates.edit', compact('electorate'));
    }

    /**
     * Update the specified electorate in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        try {
            
            $data = $this->getData($request);
            
            $electorate = Electorate::findOrFail($id);
            $electorate->update($data);

            return redirect()->route('electorates.electorate.index')
                ->with('success_message', 'ปรับปรุงข้อมูล เขตเลือกตั้ง เรียบร้อยแล้วค่ะ');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }        
    }

    /**
     * Remove the specified electorate from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        try {
            $electorate = Electorate::findOrFail($id);
            $electorate->delete();

            return redirect()->route('electorates.electorate.index')
                ->with('success_message', 'ลบข้อมูล เขตเลือกตั้ง เรียบร้อยแล้วค่ะ');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }
    }

    
    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request 
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
                'name' => 'nullable|string|min:0|max:60', 
        ];
        
        $data = $request->validate($rules);


        return $data;
    }

}
