<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Models\Mooban;
use App\Http\Models\Tambon;
use App\Http\Models\Amphur;
use App\Http\Models\User;
use Illuminate\Http\Request;
use Exception;

class MoobansController extends Controller
{

    /**
     * Display a listing of the moobans.
     *
     * @return Illuminate\View\View
     */
    public function index(Request $request)
    {
        $moobans = Mooban::with('tambon');
        if($request->input('amphurs_id')!='')
        {
           $moobans->where('tambons_id','like',  $request->input('amphurs_id') .'%');
        }
          if($request->input('tambons_id')!='')
        {
           $moobans->where('tambons_id',   $request->input('tambons_id')  );
        }
        
        $moobans = $moobans ->paginate(25)->withQueryString();
        $tambons = Tambon::pluck('name','id')->all();
        $amphurs = Amphur::pluck('name_th','id')->all();
        return view('moobans.index', compact('moobans','tambons','amphurs'));
    }

    /**
     * Show the form for creating a new mooban.
     *
     * @return Illuminate\View\View
     */
    public function create()
    {
        $tambons = Tambon::pluck('name','id')->all();
$users = User::pluck('name','id')->all();
        
        return view('moobans.create', compact('tambons','users'));
    }

    /**
     * Store a new mooban in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        try {
            
            $data = $this->getData($request);
            
            Mooban::create($data);

            return redirect()->route('moobans.mooban.index')
                ->with('success_message', 'เพิ่ม ข้อมูลหมู่บ้าน ใหม่แล้ว');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }
    }

    /**
     * Display the specified mooban.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function show($id)
    {
        $mooban = Mooban::with('tambon','user')->findOrFail($id);

        return view('moobans.show', compact('mooban'));
    }

    /**
     * Show the form for editing the specified mooban.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        $mooban = Mooban::findOrFail($id);
        $tambons = Tambon::pluck('name','id')->all();
$users = User::pluck('name','id')->all();

        return view('moobans.edit', compact('mooban','tambons','users'));
    }

    /**
     * Update the specified mooban in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        try {
            
            $data = $this->getData($request);
            
            $mooban = Mooban::findOrFail($id);
            $mooban->update($data);

            return redirect()->route('moobans.mooban.index')
                ->with('success_message', 'ปรับปรุงข้อมูล ข้อมูลหมู่บ้าน เรียบร้อยแล้วค่ะ');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }        
    }

    /**
     * Remove the specified mooban from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        try {
            $mooban = Mooban::findOrFail($id);
            $mooban->delete();

            return redirect()->route('moobans.mooban.index')
                ->with('success_message', 'ลบข้อมูล ข้อมูลหมู่บ้าน เรียบร้อยแล้วค่ะ');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }
    }

    
    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request 
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
                'tambons_id' => 'required',
            'name' => 'nullable|string|min:0|max:100',
            'moo' => 'nullable|string|min:0|max:2',
            'last_voter' => 'nullable',
            'voter_num' => 'nullable',
            'total_pop' => 'nullable|numeric|min:-32768|max:32767',
            'total_house' => 'nullable|numeric|min:-32768|max:32767',
            'latitude' => 'nullable',
            'longitude' => 'nullable',
            'detail' => 'nullable',
            'users_id' => 'nullable', 
        ];
        
        $data = $request->validate($rules);


        return $data;
    }


    
    
public function get_mooban_by_tambon($tambons_id)
	{		
		$moobans = Mooban::where('tambons_id',$tambons_id)->get();
		return view('moobans.moobans_select', compact('moobans'));
	}	
}
