<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Models\Associate;
use App\Http\Models\People as Person;
use App\Http\Models\User;
use App\Http\Models\VoterAssessment;
use Illuminate\Http\Request;
use Exception;

class VoterAssessmentsController extends Controller
{

    /**
     * Display a listing of the voter assessments.
     *
     * @return Illuminate\View\View
     */
    public function index()
    {
        $voterAssessments = VoterAssessment::with('person','associate','user')->paginate(25);

        return view('voter_assessments.index', compact('voterAssessments'));
    }

    /**
     * Show the form for creating a new voter assessment.
     *
     * @return Illuminate\View\View
     */
    public function create()
    {
        $people = Person::pluck('name','id')->all();
$associates = Associate::pluck('name','id')->all();
$users = User::pluck('name','id')->all();
        
        return view('voter_assessments.create', compact('people','associates','users'));
    }

    /**
     * Store a new voter assessment in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        try {
            
            $data = $this->getData($request);
            
            VoterAssessment::create($data);

            return redirect()->route('voter_assessments.voter_assessment.index')
                ->with('success_message', 'เพิ่ม Voter Assessment ใหม่แล้ว');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }
    }

    /**
     * Display the specified voter assessment.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function show($id)
    {
        $voterAssessment = VoterAssessment::with('person','associate','user')->findOrFail($id);

        return view('voter_assessments.show', compact('voterAssessment'));
    }

    /**
     * Show the form for editing the specified voter assessment.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        $voterAssessment = VoterAssessment::findOrFail($id);
        $people = Person::pluck('name','id')->all();
$associates = Associate::pluck('name','id')->all();
$users = User::pluck('name','id')->all();

        return view('voter_assessments.edit', compact('voterAssessment','people','associates','users'));
    }

    /**
     * Update the specified voter assessment in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        try {
            
            $data = $this->getData($request);
            
            $voterAssessment = VoterAssessment::findOrFail($id);
            $voterAssessment->update($data);

            return redirect()->route('voter_assessments.voter_assessment.index')
                ->with('success_message', 'ปรับปรุงข้อมูล Voter Assessment เรียบร้อยแล้วค่ะ');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }        
    }

    /**
     * Remove the specified voter assessment from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        try {
            $voterAssessment = VoterAssessment::findOrFail($id);
            $voterAssessment->delete();

            return redirect()->route('voter_assessments.voter_assessment.index')
                ->with('success_message', 'ลบข้อมูล Voter Assessment เรียบร้อยแล้วค่ะ');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'พบข้อผิดพลาดค่ะ!']);
        }
    }

    
    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request 
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
                'people_id' => 'nullable',
            'assessment_date' => 'nullable|string|min:0',
            'assessment_period' => 'nullable',
            'score' => 'nullable',
            'target_number' => 'nullable|numeric',
            'associates_id' => 'nullable',
            'users_id' => 'nullable',
            'selected' => 'nullable', 
        ];
        
        $data = $request->validate($rules);


        return $data;
    }

}
