<?php

namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;

class Amphur extends Model
{
    
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'amphurs';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
                  'provinces_id',
                  'name_th',
                  'name_en',
                  'size'
              ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [];
    
    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [];
    
    /**
     * Get the province for this model.
     *
     * @return App\Http\Models\Province
     */
    public function province()
    {
        return $this->belongsTo('App\Http\Models\Province','provinces_id');
    }
 	
 

}
