<?php

namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;

class People extends Model
{
    

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'people';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
                  'idcard',
                  'homes_id',
                  'moobans_id',
                  'gender',
                  'name',
                  'born',
                  'age',
                  'tel',
                  'positions_id',
                  'educations_id',
                  'residence',
                  'residence_detail',
                  'vote_location',
                  'associates_id',
                  'image',
                  'users_id',
                  'tracking_users_id',
                  'etc',
                  'lat',
                  'lon'
              ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [];
    
    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [];
    
    /**
     * Get the home for this model.
     *
     * @return App\Http\Models\Home
     */
    public function home()
    {
        return $this->belongsTo('App\Http\Models\Home','homes_id');
    }

    /**
     * Get the mooban for this model.
     *
     * @return App\Http\Models\Mooban
     */
    public function mooban()
    {
        return $this->belongsTo('App\Http\Models\Mooban','moobans_id');
    }

    /**
     * Get the position for this model.
     *
     * @return App\Http\Models\Position
     */
    public function position()
    {
        return $this->belongsTo('App\Http\Models\Position','positions_id');
    }

    /**
     * Get the education for this model.
     *
     * @return App\Http\Models\Education
     */
    public function education()
    {
        return $this->belongsTo('App\Http\Models\Education','educations_id');
    }

    /**
     * Get the associate for this model.
     *
     * @return App\Http\Models\Associate
     */
    public function associate()
    {
        return $this->belongsTo('App\Http\Models\Associate','associates_id');
    }

    /**
     * Get the user for this model.
     *
     * @return App\Http\Models\User
     */
    public function user()
    {
        return $this->belongsTo('App\Http\Models\User','users_id');
    }

    /**
     * Get the trackingUser for this model.
     *
     * @return App\Http\Models\TrackingUser
     */
    public function trackingUser()
    {
        return $this->belongsTo('App\Http\Models\User','tracking_users_id');
    }


    /**
     * Get created_at in array format
     *
     * @param  string  $value
     * @return array
     */
    public function getCreatedAtAttribute($value)
    {
        return $value; \DateTime::createFromFormat($this->getDateFormat(), $value)->format('Y-m-d H:i:s');
    }

    /**
     * Get updated_at in array format
     *
     * @param  string  $value
     * @return array
     */
    public function getUpdatedAtAttribute($value)
    {
        return $value; \DateTime::createFromFormat($this->getDateFormat(), $value)->format('Y-m-d H:i:s');
    }

}
