<?php

namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;

class VoterAssessment extends Model
{
    

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'voter_assessments';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
                  'people_id',
                  'assessment_date',
                  'assessment_period',
                  'score',
                  'target_number',
                  'associates_id',
                  'users_id',
                  'selected'
              ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [];
    
    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [];
    
    /**
     * Get the person for this model.
     *
     * @return App\Http\Models\Person
     */
    public function person()
    {
        return $this->belongsTo('App\Http\Models\Person','people_id');
    }

    /**
     * Get the associate for this model.
     *
     * @return App\Http\Models\Associate
     */
    public function associate()
    {
        return $this->belongsTo('App\Http\Models\Associate','associates_id');
    }

    /**
     * Get the user for this model.
     *
     * @return App\Http\Models\User
     */
    public function user()
    {
        return $this->belongsTo('App\Http\Models\User','users_id');
    }


    /**
     * Get created_at in array format
     *
     * @param  string  $value
     * @return array
     */
    public function getCreatedAtAttribute($value)
    {
        return $value; \DateTime::createFromFormat($this->getDateFormat(), $value)->format('Y-m-d H:i:s');
    }

    /**
     * Get updated_at in array format
     *
     * @param  string  $value
     * @return array
     */
    public function getUpdatedAtAttribute($value)
    {
        return $value; \DateTime::createFromFormat($this->getDateFormat(), $value)->format('Y-m-d H:i:s');
    }

}
