
<div class="form-group row {{ $errors->has('provinces_id') ? 'has-error' : '' }}">
    <label for="provinces_id" class="col-md-2 control-label">รหัสจังหวัด</label>
    <div class="col-md-4">
        <select class="form-control" id="provinces_id" name="provinces_id" required="true">
        	    <option value="" style="display: none;" {{ old('provinces_id', optional($amphur)->provinces_id ?: '') == '' ? 'selected' : '' }} disabled selected>ระบุ รหัสจังหวัด</option>
        	@foreach ($provinces as $key => $province)
			    <option value="{{ $key }}" {{ old('provinces_id', optional($amphur)->provinces_id) == $key ? 'selected' : '' }}>
			    	{{ $province }}
			    </option>
			@endforeach
        </select>
        
        {!! $errors->first('provinces_id', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

<div class="form-group row {{ $errors->has('name_th') ? 'has-error' : '' }}">
    <label for="name_th" class="col-md-2 control-label">ชื่ออำเภอภาษาไทย</label>
    <div class="col-md-4">
        <input class="form-control" name="name_th" type="text" id="name_th" value="{{ old('name_th', optional($amphur)->name_th) }}" maxlength="50" placeholder="ระบุ ชื่ออำเภอภาษาไทย">
        {!! $errors->first('name_th', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

<div class="form-group row {{ $errors->has('name_en') ? 'has-error' : '' }}">
    <label for="name_en" class="col-md-2 control-label">ชื่ออำเภอภาษาอังกฤษ</label>
    <div class="col-md-4">
        <input class="form-control" name="name_en" type="text" id="name_en" value="{{ old('name_en', optional($amphur)->name_en) }}" maxlength="50" placeholder="ระบุ ชื่ออำเภอภาษาอังกฤษ">
        {!! $errors->first('name_en', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

<div class="form-group row {{ $errors->has('size') ? 'has-error' : '' }}">
    <label for="size" class="col-md-2 control-label">ขนาดอำเภอ</label>
    <div class="col-md-4">
        <select class="form-control" id="size" name="size">
        	    <option value="" style="display: none;" {{ old('size', optional($amphur)->size ?: '') == '' ? 'selected' : '' }} disabled selected>ระบุ ขนาดอำเภอ</option>
        	@foreach (['big' => 'Big',
'middle' => 'Middle',
'small' => 'Small'] as $key => $text)
			    <option value="{{ $key }}" {{ old('size', optional($amphur)->size) == $key ? 'selected' : '' }}>
			    	{{ $text }}
			    </option>
			@endforeach
        </select>
        
        {!! $errors->first('size', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

