@extends('layouts.app')

@section('content')

<div class="card">
    <div class="card-header bg-primary text-white">
	
        <h5  class="my-1 float-left">{{ isset($title) ? $title : 'อำเภอ' }}</h5>
        <div class="float-right">
            <form method="POST" action="{!! route('amphurs.amphur.destroy', $amphur->id) !!}" accept-charset="UTF-8">
            <input name="_method" value="DELETE" type="hidden">
            {{ csrf_field() }}
                <div class="btn-group btn-group-sm" role="group">
                    <a href="{{ route('amphurs.amphur.index') }}" class="btn btn-primary" title="แสดง อำเภอ ทั้งหมด">
                        <i class="fas fa-fw fa-th-list" aria-hidden="true"></i>
                    </a>
                    <a href="{{ route('amphurs.amphur.create') }}" class="btn btn-success" title="เพิ่ม อำเภอ ใหม่">
                        <i class="fas fa-fw fa-plus" aria-hidden="true"></i>
                    </a>                    
                    <a href="{{ route('amphurs.amphur.edit', $amphur->id ) }}" class="btn btn-primary" title="แก้ไขข้อมูล อำเภอ">
                        <i class="fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                    </a>
                    <button type="submit" class="btn btn-danger" title="ลบ อำเภอ ทิ้ง" onclick="return confirm('คลิก OK เพื่อยืนยันการลบ อำเภอ ')">
                        <i class="fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <div class="card-body">
         
            <div class="row">
				<div class="col-sm-4 right">รหัสจังหวัด</div>
				<div class="col-sm-8">: {{ optional($amphur->province)->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ชื่ออำเภอภาษาไทย</div>
				<div class="col-sm-8">: {{ $amphur->name_th }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ชื่ออำเภอภาษาอังกฤษ</div>
				<div class="col-sm-8">: {{ $amphur->name_en }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ขนาดอำเภอ</div>
				<div class="col-sm-8">: {{ $amphur->size }}</div>
			</div>

        

    </div>
</div>

@endsection