@extends('layouts.app')

@section('content')

    @if(Session::has('success_message'))
        <div class="alert alert-success">
            <i class=" fas fa-fw fa-check" aria-hidden="true"></i>
            {!! session('success_message') !!}

            <button type="button" class="close" data-dismiss="alert" aria-label="close">
                <span aria-hidden="true">&times;</span>
            </button>

        </div>
    @endif

    <div class="card">

        <div class="card-header bg-primary text-white">

            <h5  class="my-1 float-left">EducationS</h5>

            <div class="btn-group btn-group-sm float-right" role="group">
                <a href="{{ route('educations.education.create') }}" class="btn btn-success" title="เพิ่ม Education ใหม่">                     
					<i class="fas fa-fw  fa-plus" aria-hidden="true"></i>
                </a>
            </div>

        </div>
        
        @if(count($educations) == 0)
            <div class="card-body text-center">
                <h4>ไม่พบข้อมูล EducationS</h4>
            </div>
        @else
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-striped table-sm table-bordered">
                    <thead>
                        <tr>
						<th>ลำดับที่</th>
                                <th>ระดับการศึกษา</th>

                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
					 <?php $r = 0 ; if(isset($_REQUEST['page']) && $_REQUEST['page'] > 1 ){$r = 25 * ($_REQUEST['page']-1);}?>
                    @foreach($educations as $education)
                        <tr>
						<td>{{++$r}}</td>
						
                                <td>{{ $education->name }}</td>

                            <td>

                                <form method="POST" action="{!! route('educations.education.destroy', $education->id) !!}" accept-charset="UTF-8">
                                <input name="_method" value="DELETE" type="hidden">
                                {{ csrf_field() }}

                                    <div class="btn-group btn-group-sm float-right" role="group">
                                        <a href="{{ route('educations.education.show', $education->id ) }}" class="btn btn-info" title="แสดงข้อมูล Education">
                                            <i class=" fas fa-fw fa-eye" aria-hidden="true"></i>
                                        </a>
                                        <a href="{{ route('educations.education.edit', $education->id ) }}" class="btn btn-primary" title="แก้ไขข้อมูล Education">
                                            <i class=" fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                                        </a>

                                        <button type="submit" class="btn btn-danger" title="ลบ Education ทิ้ง" onclick="return confirm('คลิก OK เพื่อยืนยันการลบ Education ')">
                                            <i class=" fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                                        </button>
                                    </div>

                                </form>
                                
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>

            </div>
        </div>

        <div class="card-footer">
            {!! $educations->render() !!}
        </div>
        
        @endif
    
    </div>
@endsection