@extends('layouts.app')

@section('content')

<div class="card">
    <div class="card-header bg-primary text-white">
	
        <h5  class="my-1 float-left">{{ isset($electorate->name) ? $electorate->name : 'เขตเลือกตั้ง' }}</h5>
        <div class="float-right">
            <form method="POST" action="{!! route('electorates.electorate.destroy', $electorate->id) !!}" accept-charset="UTF-8">
            <input name="_method" value="DELETE" type="hidden">
            {{ csrf_field() }}
                <div class="btn-group btn-group-sm" role="group">
                    <a href="{{ route('electorates.electorate.index') }}" class="btn btn-primary" title="แสดง เขตเลือกตั้ง ทั้งหมด">
                        <i class="fas fa-fw fa-th-list" aria-hidden="true"></i>
                    </a>
                    <a href="{{ route('electorates.electorate.create') }}" class="btn btn-success" title="เพิ่ม เขตเลือกตั้ง ใหม่">
                        <i class="fas fa-fw fa-plus" aria-hidden="true"></i>
                    </a>                    
                    <a href="{{ route('electorates.electorate.edit', $electorate->id ) }}" class="btn btn-primary" title="แก้ไขข้อมูล เขตเลือกตั้ง">
                        <i class="fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                    </a>
                    <button type="submit" class="btn btn-danger" title="ลบ เขตเลือกตั้ง ทิ้ง" onclick="return confirm('คลิก OK เพื่อยืนยันการลบ เขตเลือกตั้ง ')">
                        <i class="fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <div class="card-body">
         
            <div class="row">
				<div class="col-sm-4 right">เขตเลือกตั้ง</div>
				<div class="col-sm-8">: {{ $electorate->name }}</div>
			</div>

        

    </div>
</div>

@endsection