@extends('layouts.app')

@section('content')

<div class="card">
    <div class="card-header bg-primary text-white">
	
        <h5  class="my-1 float-left">{{ isset($title) ? $title : 'Leader Assessment' }}</h5>
        <div class="float-right">
            <form method="POST" action="{!! route('leader_assessments.leader_assessment.destroy', $leaderAssessment->id) !!}" accept-charset="UTF-8">
            <input name="_method" value="DELETE" type="hidden">
            {{ csrf_field() }}
                <div class="btn-group btn-group-sm" role="group">
                    <a href="{{ route('leader_assessments.leader_assessment.index') }}" class="btn btn-primary" title="แสดง Leader Assessment ทั้งหมด">
                        <i class="fas fa-fw fa-th-list" aria-hidden="true"></i>
                    </a>
                    <a href="{{ route('leader_assessments.leader_assessment.create') }}" class="btn btn-success" title="เพิ่ม Leader Assessment ใหม่">
                        <i class="fas fa-fw fa-plus" aria-hidden="true"></i>
                    </a>                    
                    <a href="{{ route('leader_assessments.leader_assessment.edit', $leaderAssessment->id ) }}" class="btn btn-primary" title="แก้ไขข้อมูล Leader Assessment">
                        <i class="fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                    </a>
                    <button type="submit" class="btn btn-danger" title="ลบ Leader Assessment ทิ้ง" onclick="return confirm('คลิก OK เพื่อยืนยันการลบ Leader Assessment ')">
                        <i class="fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <div class="card-body">
         
            <div class="row">
				<div class="col-sm-4 right">บุคคล</div>
				<div class="col-sm-8">: {{ optional($leaderAssessment->person)->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">วันที่ประเมิน</div>
				<div class="col-sm-8">: {{ $leaderAssessment->assessment_date }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ครั้งที่ประเมิน</div>
				<div class="col-sm-8">: {{ $leaderAssessment->assessment_period }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">การแสดงออกทางการเมือง</div>
				<div class="col-sm-8">: {{ $leaderAssessment->expression }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ขีดความสามารถการแสดงออก</div>
				<div class="col-sm-8">: {{ $leaderAssessment->performance }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">บารมี/ความน่าเชื่อถือ</div>
				<div class="col-sm-8">: {{ $leaderAssessment->dependability }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ฝักไฝ่ฝ่ายเรา</div>
				<div class="col-sm-8">: {{ $leaderAssessment->associate }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ผู้บันทึกข้อมูล</div>
				<div class="col-sm-8">: {{ optional($leaderAssessment->user)->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right"></div>
				<div class="col-sm-8">: {{ $leaderAssessment->created_at }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right"></div>
				<div class="col-sm-8">: {{ $leaderAssessment->updated_at }}</div>
			</div>

        

    </div>
</div>

@endsection