@extends('layouts.app')

@section('content')

<div class="card">
    <div class="card-header bg-primary text-white">
	
        <h5  class="my-1 float-left">{{ isset($people->name) ? $people->name : 'ผู้มีสิทธิ์เลือกตั้ง' }}</h5>
        <div class="float-right">
            <form method="POST" action="{!! route('people.people.destroy', $people->id) !!}" accept-charset="UTF-8">
            <input name="_method" value="DELETE" type="hidden">
            {{ csrf_field() }}
                <div class="btn-group btn-group-sm" role="group">
                    <a href="{{ route('people.people.index') }}" class="btn btn-primary" title="แสดง ผู้มีสิทธิ์เลือกตั้ง ทั้งหมด">
                        <i class="fas fa-fw fa-th-list" aria-hidden="true"></i>
                    </a>
                    <a href="{{ route('people.people.create') }}" class="btn btn-success" title="เพิ่ม ผู้มีสิทธิ์เลือกตั้ง ใหม่">
                        <i class="fas fa-fw fa-plus" aria-hidden="true"></i>
                    </a>                    
                    <a href="{{ route('people.people.edit', $people->id ) }}" class="btn btn-primary" title="แก้ไขข้อมูล ผู้มีสิทธิ์เลือกตั้ง">
                        <i class="fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                    </a>
                    <button type="submit" class="btn btn-danger" title="ลบ ผู้มีสิทธิ์เลือกตั้ง ทิ้ง" onclick="return confirm('คลิก OK เพื่อยืนยันการลบ ผู้มีสิทธิ์เลือกตั้ง ')">
                        <i class="fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <div class="card-body">
         
            <div class="row">
				<div class="col-sm-4 right">เลขบัตรประชาชน</div>
				<div class="col-sm-8">: {{ $people->idcard }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">บ้านเลขที่</div>
				<div class="col-sm-8">: {{ optional($people->home)->address }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">หมู่บ้าน</div>
				<div class="col-sm-8">: {{ optional($people->mooban)->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">เพศ</div>
				<div class="col-sm-8">: {{ $people->gender }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ชื่อ-สกุล</div>
				<div class="col-sm-8">: {{ $people->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ปีเกิด</div>
				<div class="col-sm-8">: {{ $people->born }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">อายุ</div>
				<div class="col-sm-8">: {{ $people->age }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">เบอร์โทร</div>
				<div class="col-sm-8">: {{ $people->tel }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ตำแหน่ง/ยศ</div>
				<div class="col-sm-8">: {{ optional($people->position)->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ระดับการศึกษา</div>
				<div class="col-sm-8">: {{ optional($people->education)->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ถิ่นที่อยู่</div>
				<div class="col-sm-8">: {{ $people->residence }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">รายละเอียดถิ่นที่อยู่(กรณีนอกพื้นที่ ถ้ามี)</div>
				<div class="col-sm-8">: {{ $people->residence_detail }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">การเลือกตั้งในเขต</div>
				<div class="col-sm-8">: {{ $people->vote_location }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ฝ่าย</div>
				<div class="col-sm-8">: {{ optional($people->associate)->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ภาพ</div>
				<div class="col-sm-8">: {{ asset('storage/' . $people->image) }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ผู้บันทึกข้อมูล</div>
				<div class="col-sm-8">: {{ optional($people->user)->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ผู้รับผิดชอบในการหาเสียง</div>
				<div class="col-sm-8">: {{ optional($people->trackingUser)->id }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">คำอธิบาย บุคคลเพิ่มเติม</div>
				<div class="col-sm-8">: {{ $people->etc }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ละติจูด</div>
				<div class="col-sm-8">: {{ $people->lat }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ลองจิจูด</div>
				<div class="col-sm-8">: {{ $people->lon }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right"></div>
				<div class="col-sm-8">: {{ $people->created_at }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right"></div>
				<div class="col-sm-8">: {{ $people->updated_at }}</div>
			</div>

        

    </div>
</div>

@endsection