
<div class="form-group row {{ $errors->has('name') ? 'has-error' : '' }}">
    <label for="name" class="col-md-2 control-label">ชื่อ-สกุล</label>
    <div class="col-md-4">
        <input class="form-control" name="name" type="text" id="name" value="{{ old('name', optional($user)->name) }}" maxlength="70" placeholder="ระบุ ชื่อ-สกุล">
        {!! $errors->first('name', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

<div class="form-group row {{ $errors->has('tel') ? 'has-error' : '' }}">
    <label for="tel" class="col-md-2 control-label">เบอร์โทร</label>
    <div class="col-md-4">
        <input class="form-control" name="tel" type="text" id="tel" value="{{ old('tel', optional($user)->tel) }}" maxlength="30" placeholder="ระบุ เบอร์โทร">
        {!! $errors->first('tel', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

<div class="form-group row {{ $errors->has('email') ? 'has-error' : '' }}">
    <label for="email" class="col-md-2 control-label">E-mail</label>
    <div class="col-md-4">
        <input class="form-control" name="email" type="text" id="email" value="{{ old('email', optional($user)->email) }}" maxlength="60" placeholder="ระบุ E-mail">
        {!! $errors->first('email', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

<div class="form-group row {{ $errors->has('username') ? 'has-error' : '' }}">
    <label for="username" class="col-md-2 control-label">ผู้ใช้งานระบบname</label>
    <div class="col-md-4">
        <input class="form-control" name="username" type="text" id="username" value="{{ old('username', optional($user)->username) }}" maxlength="20" placeholder="ระบุ ผู้ใช้งานระบบname">
        {!! $errors->first('username', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

<div class="form-group row {{ $errors->has('password') ? 'has-error' : '' }}">
    <label for="password" class="col-md-2 control-label">รหัสผ่าน</label>
    <div class="col-md-4">
        <input class="form-control" name="password" type="text" id="password" value="{{ old('password', optional($user)->password) }}" maxlength="70" placeholder="ระบุ รหัสผ่าน">
        {!! $errors->first('password', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

<div class="form-group row {{ $errors->has('permission') ? 'has-error' : '' }}">
    <label for="permission" class="col-md-2 control-label">สิทธิ์</label>
    <div class="col-md-4">
        <select class="form-control" id="permission" name="permission">
        	    <option value="" style="display: none;" {{ old('permission', optional($user)->permission ?: '') == '' ? 'selected' : '' }} disabled selected>ระบุ สิทธิ์</option>
        	@foreach (['ADMIN' => 'ADMIN สูงสุด',
'ADMIN_AMP' => 'ADMIN อำเภอ',
'ADMIN_TAMBON' => 'ADMIN ตำบล',
'USER_MOOBAN' => 'แกนนำหมู่บ้าน'] as $key => $text)
			    <option value="{{ $key }}" {{ old('permission', optional($user)->permission) == $key ? 'selected' : '' }}>
			    	{{ $text }}
			    </option>
			@endforeach
        </select>
        
        {!! $errors->first('permission', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

<div class="form-group row {{ $errors->has('image') ? 'has-error' : '' }}">
    <label for="image" class="col-md-2 control-label">ภาพโปรไฟล์</label>
    <div class="col-md-4">
        <div class="input-group uploaded-file-group">
            <label class="input-group-btn">
                <span class="btn btn-default">
                   ไฟล์เอกสาร (ถ้ามี)<input type="file" name="image" id="image" class="hidden">
                </span>
            </label>
            <input type="text" class="form-control uploaded-file-name" readonly>
        </div>

        @if (isset($user->image) && !empty($user->image))
            <div class="input-group input-width-input">
                <span class="input-group-addon">
                    <input type="checkbox" name="custom_delete_image" class="custom-delete-file" value="1" {{ old('custom_delete_image', '0') == '1' ? 'checked' : '' }}> Delete
                </span>

                <span class="input-group-addon custom-delete-file-name">
                    {{ $user->image }}
                </span>
            </div>
        @endif
        {!! $errors->first('image', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>

<div class="form-group row {{ $errors->has('etc') ? 'has-error' : '' }}">
    <label for="etc" class="col-md-2 control-label">อื่นๆ</label>
    <div class="col-md-4">
        <input class="form-control" name="etc" type="text" id="etc" value="{{ old('etc', optional($user)->etc) }}" maxlength="500" placeholder="ระบุ อื่นๆ">
        {!! $errors->first('etc', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>


<div class="form-group row {{ $errors->has('electorates_id') ? 'has-error' : '' }}">
    <label for="electorates_id" class="col-md-2 control-label">ควบคุมเขตเลือกตั้ง</label>
    <div class="col-md-4">
        <select class="form-control" id="electorates_id" name="electorates_id">
        	    <option value="" style="display: none;" {{ old('electorates_id', optional($user)->electorates_id ?: '') == '' ? 'selected' : '' }} disabled selected>ระบุ ควบคุมเขตเลือกตั้ง</option>
        	@foreach ($electorates as $key => $electorate)
			    <option value="{{ $key }}" {{ old('electorates_id', optional($user)->electorates_id) == $key ? 'selected' : '' }}>
			    	{{ $electorate }}
			    </option>
			@endforeach
        </select>
        
        {!! $errors->first('electorates_id', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>


<div class="form-group row {{ $errors->has('amphurs_id') ? 'has-error' : '' }}">
    <label for="amphurs_id" class="col-md-2 control-label">ควบคุมอำเภอ</label>
    <div class="col-md-4">
        <select class="form-control" id="amphurs_id" name="amphurs_id">
        	    <option value="" style="display: none;" {{ old('amphurs_id', optional($user)->amphurs_id ?: '') == '' ? 'selected' : '' }} disabled selected>ระบุ ควบคุมอำเภอ</option>
        	@foreach ($amphurs as $key => $amphur)
			    <option value="{{ $key }}" {{ old('amphurs_id', optional($user)->amphurs_id) == $key ? 'selected' : '' }}>
			    	{{ $amphur }}
			    </option>
			@endforeach
        </select>
        
        {!! $errors->first('amphurs_id', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>




<div class="form-group row {{ $errors->has('tambons_id') ? 'has-error' : '' }}">
    <label for="tambons_id" class="col-md-2 control-label">ควบคุมตำบล</label>
    <div class="col-md-4">
        <select class="form-control" id="tambons_id" name="tambons_id">
        	    <option value="" style="display: none;" {{ old('tambons_id', optional($user)->tambons_id ?: '') == '' ? 'selected' : '' }} disabled selected>ระบุ ควบคุมตำบล</option>
        	@foreach ($tambons as $key => $tambon)
			    <option value="{{ $key }}" {{ old('tambons_id', optional($user)->tambons_id) == $key ? 'selected' : '' }}>
			    	{{ $tambon }}
			    </option>
			@endforeach
        </select>
        
        {!! $errors->first('tambons_id', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>


<div class="form-group row {{ $errors->has('moobans_id') ? 'has-error' : '' }}">
    <label for="moobans_id" class="col-md-2 control-label">ควบคุมหมู่บ้าน</label>
    <div class="col-md-4">
        <select class="form-control" id="moobans_id" name="moobans_id">
        	    <option value="" style="display: none;" {{ old('moobans_id', optional($user)->moobans_id ?: '') == '' ? 'selected' : '' }} disabled selected>ระบุ ควบคุมหมู่บ้าน</option>
        	@foreach ($moobans as $key => $mooban)
			    <option value="{{ $key }}" {{ old('moobans_id', optional($user)->moobans_id) == $key ? 'selected' : '' }}>
			    	{{ $mooban }}
			    </option>
			@endforeach
        </select>
        
        {!! $errors->first('moobans_id', '<p class="form-text text-muted">:message</p>') !!}
    </div>
</div>