@extends('layouts.app')

@section('content')

<div class="card">
    <div class="card-header bg-primary text-white">
	
        <h5  class="my-1 float-left">{{ isset($user->name) ? $user->name : 'ผู้ใช้งานระบบ' }}</h5>
        <div class="float-right">
            <form method="POST" action="{!! route('users.user.destroy', $user->id) !!}" accept-charset="UTF-8">
            <input name="_method" value="DELETE" type="hidden">
            {{ csrf_field() }}
                <div class="btn-group btn-group-sm" role="group">
                    <a href="{{ route('users.user.index') }}" class="btn btn-primary" title="แสดง ผู้ใช้งานระบบ ทั้งหมด">
                        <i class="fas fa-fw fa-th-list" aria-hidden="true"></i>
                    </a>
                    <a href="{{ route('users.user.create') }}" class="btn btn-success" title="เพิ่ม ผู้ใช้งานระบบ ใหม่">
                        <i class="fas fa-fw fa-plus" aria-hidden="true"></i>
                    </a>                    
                    <a href="{{ route('users.user.edit', $user->id ) }}" class="btn btn-primary" title="แก้ไขข้อมูล ผู้ใช้งานระบบ">
                        <i class="fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                    </a>
                    <button type="submit" class="btn btn-danger" title="ลบ ผู้ใช้งานระบบ ทิ้ง" onclick="return confirm('คลิก OK เพื่อยืนยันการลบ ผู้ใช้งานระบบ ')">
                        <i class="fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <div class="card-body">
         
            <div class="row">
				<div class="col-sm-4 right">ชื่อ-สกุล</div>
				<div class="col-sm-8">: {{ $user->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">เบอร์โทร</div>
				<div class="col-sm-8">: {{ $user->tel }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">E-mail</div>
				<div class="col-sm-8">: {{ $user->email }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ผู้ใช้งานระบบname</div>
				<div class="col-sm-8">: {{ $user->username }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">สิทธิ์</div>
				<div class="col-sm-8">: {{ $user->permission }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ภาพโปรไฟล์</div>
				<div class="col-sm-8">: {{ asset('storage/' . $user->image) }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">อื่นๆ</div>
				<div class="col-sm-8">: {{ $user->etc }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ควบคุมหมู่บ้าน</div>
				<div class="col-sm-8">: {{ optional($user->mooban)->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ควบคุมตำบล</div>
				<div class="col-sm-8">: {{ optional($user->tambon)->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ควบคุมอำเภอ</div>
				<div class="col-sm-8">: {{ optional($user->amphur)->name_th }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ควบคุมเขตเลือกตั้ง</div>
				<div class="col-sm-8">: {{ optional($user->electorate)->id }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right"></div>
				<div class="col-sm-8">: {{ $user->created_at }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right"></div>
				<div class="col-sm-8">: {{ $user->updated_at }}</div>
			</div>

        

    </div>
</div>

@endsection