@extends('layouts.app')

@section('content')

<div class="card">
    <div class="card-header bg-primary text-white">
	
        <h5  class="my-1 float-left">{{ isset($title) ? $title : 'Voter Assessment' }}</h5>
        <div class="float-right">
            <form method="POST" action="{!! route('voter_assessments.voter_assessment.destroy', $voterAssessment->id) !!}" accept-charset="UTF-8">
            <input name="_method" value="DELETE" type="hidden">
            {{ csrf_field() }}
                <div class="btn-group btn-group-sm" role="group">
                    <a href="{{ route('voter_assessments.voter_assessment.index') }}" class="btn btn-primary" title="แสดง Voter Assessment ทั้งหมด">
                        <i class="fas fa-fw fa-th-list" aria-hidden="true"></i>
                    </a>
                    <a href="{{ route('voter_assessments.voter_assessment.create') }}" class="btn btn-success" title="เพิ่ม Voter Assessment ใหม่">
                        <i class="fas fa-fw fa-plus" aria-hidden="true"></i>
                    </a>                    
                    <a href="{{ route('voter_assessments.voter_assessment.edit', $voterAssessment->id ) }}" class="btn btn-primary" title="แก้ไขข้อมูล Voter Assessment">
                        <i class="fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                    </a>
                    <button type="submit" class="btn btn-danger" title="ลบ Voter Assessment ทิ้ง" onclick="return confirm('คลิก OK เพื่อยืนยันการลบ Voter Assessment ')">
                        <i class="fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <div class="card-body">
         
            <div class="row">
				<div class="col-sm-4 right">บุคคล</div>
				<div class="col-sm-8">: {{ optional($voterAssessment->person)->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">วันที่ประเมิน</div>
				<div class="col-sm-8">: {{ $voterAssessment->assessment_date }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ครั้งที่ประเมิน</div>
				<div class="col-sm-8">: {{ $voterAssessment->assessment_period }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">โอกาสได้คะแนน</div>
				<div class="col-sm-8">: {{ $voterAssessment->score }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">เบอร์ที่คาดว่าจะให้คะแนน</div>
				<div class="col-sm-8">: {{ $voterAssessment->target_number }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">พรรคที่คาดว่าจะให้คะแนน</div>
				<div class="col-sm-8">: {{ optional($voterAssessment->associate)->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right">ผู้บันทึกข้อมูล</div>
				<div class="col-sm-8">: {{ optional($voterAssessment->user)->name }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right"></div>
				<div class="col-sm-8">: {{ $voterAssessment->selected }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right"></div>
				<div class="col-sm-8">: {{ $voterAssessment->created_at }}</div>
			</div>
            <div class="row">
				<div class="col-sm-4 right"></div>
				<div class="col-sm-8">: {{ $voterAssessment->updated_at }}</div>
			</div>

        

    </div>
</div>

@endsection