<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes([
     'register' => false,
     'reset' => false,
]);

     Route::any('/logout', 'Auth\LogoutController@perform')->name('logout.perform');
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::group([
    'prefix' => 'users',
], function () {
    Route::get('/', 'UsersController@index')
         ->name('users.user.index');
    Route::get('/create','UsersController@create')
         ->name('users.user.create');
    Route::get('/show/{user}','UsersController@show')
         ->name('users.user.show')->where('id', '[0-9]+');
    Route::get('/{user}/edit','UsersController@edit')
         ->name('users.user.edit')->where('id', '[0-9]+');
    Route::post('/', 'UsersController@store')
         ->name('users.user.store');
    Route::put('user/{user}', 'UsersController@update')
         ->name('users.user.update')->where('id', '[0-9]+');
    Route::delete('/user/{user}','UsersController@destroy')
         ->name('users.user.destroy')->where('id', '[0-9]+');
});

Route::group([
    'prefix' => 'electorates',
], function () {
    Route::get('/', 'ElectoratesController@index')
         ->name('electorates.electorate.index');
    Route::get('/create','ElectoratesController@create')
         ->name('electorates.electorate.create');
    Route::get('/show/{electorate}','ElectoratesController@show')
         ->name('electorates.electorate.show')->where('id', '[0-9]+');
    Route::get('/{electorate}/edit','ElectoratesController@edit')
         ->name('electorates.electorate.edit')->where('id', '[0-9]+');
    Route::post('/', 'ElectoratesController@store')
         ->name('electorates.electorate.store');
    Route::put('electorate/{electorate}', 'ElectoratesController@update')
         ->name('electorates.electorate.update')->where('id', '[0-9]+');
    Route::delete('/electorate/{electorate}','ElectoratesController@destroy')
         ->name('electorates.electorate.destroy')->where('id', '[0-9]+');
});

Route::group([
    'prefix' => 'amphurs',
], function () {
    Route::get('/', 'AmphursController@index')
         ->name('amphurs.amphur.index');
    Route::get('/create','AmphursController@create')
         ->name('amphurs.amphur.create');
    Route::get('/show/{amphur}','AmphursController@show')
         ->name('amphurs.amphur.show')->where('id', '[0-9]+');
    Route::get('/{amphur}/edit','AmphursController@edit')
         ->name('amphurs.amphur.edit')->where('id', '[0-9]+');
    Route::post('/', 'AmphursController@store')
         ->name('amphurs.amphur.store');
    Route::put('amphur/{amphur}', 'AmphursController@update')
         ->name('amphurs.amphur.update')->where('id', '[0-9]+');
    Route::delete('/amphur/{amphur}','AmphursController@destroy')
         ->name('amphurs.amphur.destroy')->where('id', '[0-9]+');
});

Route::group([
    'prefix' => 'tambons',
], function () {
    Route::get('/', 'TambonsController@index')
         ->name('tambons.tambon.index');
    Route::get('/create','TambonsController@create')
         ->name('tambons.tambon.create');
    Route::get('/show/{tambon}','TambonsController@show')
         ->name('tambons.tambon.show')->where('id', '[0-9]+');
    Route::get('/{tambon}/edit','TambonsController@edit')
         ->name('tambons.tambon.edit')->where('id', '[0-9]+');
    Route::post('/', 'TambonsController@store')
         ->name('tambons.tambon.store');
    Route::put('tambon/{tambon}', 'TambonsController@update')
         ->name('tambons.tambon.update')->where('id', '[0-9]+');
    Route::delete('/tambon/{tambon}','TambonsController@destroy')
         ->name('tambons.tambon.destroy')->where('id', '[0-9]+');
         
});

Route::group([
    'prefix' => 'moobans',
], function () {
    Route::get('/', 'MoobansController@index')
         ->name('moobans.mooban.index');
    Route::get('/create','MoobansController@create')
         ->name('moobans.mooban.create');
    Route::get('/show/{mooban}','MoobansController@show')
         ->name('moobans.mooban.show')->where('id', '[0-9]+');
    Route::get('/{mooban}/edit','MoobansController@edit')
         ->name('moobans.mooban.edit')->where('id', '[0-9]+');
    Route::post('/', 'MoobansController@store')
         ->name('moobans.mooban.store');
    Route::put('mooban/{mooban}', 'MoobansController@update')
         ->name('moobans.mooban.update')->where('id', '[0-9]+');
    Route::delete('/mooban/{mooban}','MoobansController@destroy')
         ->name('moobans.mooban.destroy')->where('id', '[0-9]+');
});

Route::group([
    'prefix' => 'associates',
], function () {
    Route::get('/', 'AssociatesController@index')
         ->name('associates.associate.index');
    Route::get('/create','AssociatesController@create')
         ->name('associates.associate.create');
    Route::get('/show/{associate}','AssociatesController@show')
         ->name('associates.associate.show')->where('id', '[0-9]+');
    Route::get('/{associate}/edit','AssociatesController@edit')
         ->name('associates.associate.edit')->where('id', '[0-9]+');
    Route::post('/', 'AssociatesController@store')
         ->name('associates.associate.store');
    Route::put('associate/{associate}', 'AssociatesController@update')
         ->name('associates.associate.update')->where('id', '[0-9]+');
    Route::delete('/associate/{associate}','AssociatesController@destroy')
         ->name('associates.associate.destroy')->where('id', '[0-9]+');
});

Route::group([
    'prefix' => 'educations',
], function () {
    Route::get('/', 'educationsController@index')
         ->name('educations.education.index');
    Route::get('/create','educationsController@create')
         ->name('educations.education.create');
    Route::get('/show/{education}','educationsController@show')
         ->name('educations.education.show')->where('id', '[0-9]+');
    Route::get('/{education}/edit','educationsController@edit')
         ->name('educations.education.edit')->where('id', '[0-9]+');
    Route::post('/', 'educationsController@store')
         ->name('educations.education.store');
    Route::put('education/{education}', 'educationsController@update')
         ->name('educations.education.update')->where('id', '[0-9]+');
    Route::delete('/education/{education}','educationsController@destroy')
         ->name('educations.education.destroy')->where('id', '[0-9]+');
});

Route::group([
    'prefix' => 'homes',
], function () {
    Route::get('/', 'HomesController@index')
         ->name('homes.home.index');
    Route::get('/create','HomesController@create')
         ->name('homes.home.create');
    Route::get('/show/{home}','HomesController@show')
         ->name('homes.home.show')->where('id', '[0-9]+');
    Route::get('/{home}/edit','HomesController@edit')
         ->name('homes.home.edit')->where('id', '[0-9]+');
    Route::post('/', 'HomesController@store')
         ->name('homes.home.store');
    Route::put('home/{home}', 'HomesController@update')
         ->name('homes.home.update')->where('id', '[0-9]+');
    Route::delete('/home/{home}','HomesController@destroy')
         ->name('homes.home.destroy')->where('id', '[0-9]+');
});

Route::group([
    'prefix' => 'people',
], function () {
    Route::get('/', 'PeopleController@index')
         ->name('people.people.index');
    Route::get('/create','PeopleController@create')
         ->name('people.people.create');
    Route::get('/show/{people}','PeopleController@show')
         ->name('people.people.show')->where('id', '[0-9]+');
    Route::get('/{people}/edit','PeopleController@edit')
         ->name('people.people.edit')->where('id', '[0-9]+');
    Route::post('/', 'PeopleController@store')
         ->name('people.people.store');
    Route::put('people/{people}', 'PeopleController@update')
         ->name('people.people.update')->where('id', '[0-9]+');
    Route::delete('/people/{people}','PeopleController@destroy')
         ->name('people.people.destroy')->where('id', '[0-9]+');
});

Route::group([
    'prefix' => 'positions',
], function () {
    Route::get('/', 'PositionsController@index')
         ->name('positions.position.index');
    Route::get('/create','PositionsController@create')
         ->name('positions.position.create');
    Route::get('/show/{position}','PositionsController@show')
         ->name('positions.position.show')->where('id', '[0-9]+');
    Route::get('/{position}/edit','PositionsController@edit')
         ->name('positions.position.edit')->where('id', '[0-9]+');
    Route::post('/', 'PositionsController@store')
         ->name('positions.position.store');
    Route::put('position/{position}', 'PositionsController@update')
         ->name('positions.position.update')->where('id', '[0-9]+');
    Route::delete('/position/{position}','PositionsController@destroy')
         ->name('positions.position.destroy')->where('id', '[0-9]+');
});

Route::group([
    'prefix' => 'leader_assessments',
], function () {
    Route::get('/', 'LeaderAssessmentsController@index')
         ->name('leader_assessments.leader_assessment.index');
    Route::get('/create','LeaderAssessmentsController@create')
         ->name('leader_assessments.leader_assessment.create');
    Route::get('/show/{leaderAssessment}','LeaderAssessmentsController@show')
         ->name('leader_assessments.leader_assessment.show')->where('id', '[0-9]+');
    Route::get('/{leaderAssessment}/edit','LeaderAssessmentsController@edit')
         ->name('leader_assessments.leader_assessment.edit')->where('id', '[0-9]+');
    Route::post('/', 'LeaderAssessmentsController@store')
         ->name('leader_assessments.leader_assessment.store');
    Route::put('leader_assessment/{leaderAssessment}', 'LeaderAssessmentsController@update')
         ->name('leader_assessments.leader_assessment.update')->where('id', '[0-9]+');
    Route::delete('/leader_assessment/{leaderAssessment}','LeaderAssessmentsController@destroy')
         ->name('leader_assessments.leader_assessment.destroy')->where('id', '[0-9]+');
});

Route::group([
    'prefix' => 'voter_assessments',
], function () {
    Route::get('/', 'VoterAssessmentsController@index')
         ->name('voter_assessments.voter_assessment.index');
    Route::get('/create','VoterAssessmentsController@create')
         ->name('voter_assessments.voter_assessment.create');
    Route::get('/show/{voterAssessment}','VoterAssessmentsController@show')
         ->name('voter_assessments.voter_assessment.show')->where('id', '[0-9]+');
    Route::get('/{voterAssessment}/edit','VoterAssessmentsController@edit')
         ->name('voter_assessments.voter_assessment.edit')->where('id', '[0-9]+');
    Route::post('/', 'VoterAssessmentsController@store')
         ->name('voter_assessments.voter_assessment.store');
    Route::put('voter_assessment/{voterAssessment}', 'VoterAssessmentsController@update')
         ->name('voter_assessments.voter_assessment.update')->where('id', '[0-9]+');
    Route::delete('/voter_assessment/{voterAssessment}','VoterAssessmentsController@destroy')
         ->name('voter_assessments.voter_assessment.destroy')->where('id', '[0-9]+');
});


Route::post('/get_tambon_by_amphur/{id}','TambonsController@get_tambon_by_amphur')
         ->name('tambons.tambon.get_tambon_by_amphur')->where('id', '[0-9]+');

Route::post('/get_mooban_by_tambon/{id}','MoobansController@get_mooban_by_tambon')
         ->name('moobans.mooban.get_mooban_by_tambon')->where('id', '[0-9]+');

Route::post('/get_home_by_mooban/{id}','HomesController@get_home_by_mooban')
         ->name('homes.home.get_home_by_mooban')->where('id', '[0-9]+');