

<?php $__env->startSection('content'); ?>

    <?php if(Session::has('success_message')): ?>
        <div class="alert alert-success">
            <i class=" fas fa-fw fa-check" aria-hidden="true"></i>
            <?php echo session('success_message'); ?>


            <button type="button" class="close" data-dismiss="alert" aria-label="close">
                <span aria-hidden="true">&times;</span>
            </button>

        </div>
    <?php endif; ?>

    <div class="card">

        <div class="card-header bg-primary text-white">

            <h5  class="my-1 float-left">บ้านเลขที่</h5>

            <div class="btn-group btn-group-sm float-right" role="group">
                <a href="<?php echo e(route('homes.home.create')); ?>" class="btn btn-success" title="เพิ่ม บ้านเลขที่ ใหม่">                     
					<i class="fas fa-fw  fa-plus" aria-hidden="true"></i>
                </a>
            </div>

        </div>
        
        <?php if(count($homes) == 0): ?>
            <div class="card-body text-center">
                <h4>ไม่พบข้อมูล บ้านเลขที่</h4>
            </div>
        <?php else: ?>
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-striped table-sm table-bordered">
                    <thead>
                        <tr>
						<th>ลำดับที่</th>
                                <th>เขตเลือกตั้ง</th>
                            <th>อำเภอ</th>
                            <th>ตำบล</th>
                            <th>หมู่บ้าน</th>
                            <th>หมู่ที่</th>
                            <th>บ้านเลขที่</th>
                            <th>ผู้บันทึกข้อมูล</th>
                            <th>หมายเหตุ</th>

                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
					 <?php $r = 0 ; if(isset($_REQUEST['page']) && $_REQUEST['page'] > 1 ){$r = 25 * ($_REQUEST['page']-1);}?>
                    <?php $__currentLoopData = $homes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $home): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
						<td><?php echo e(++$r); ?></td>
						
                                <td><?php echo e(optional($home->electorate)->name); ?></td>
                            <td><?php echo e(optional($home->amphur)->name_th); ?></td>
                            <td><?php echo e(optional($home->tambon)->name); ?></td>
                            <td><?php echo e(optional($home->mooban)->name); ?></td>            <td><?php echo e((int)optional($home->mooban)->moo); ?></td>
                            <td><?php echo e($home->address); ?></td>
                            <td><?php echo e(optional($home->user)->name); ?></td>
                            <td><?php echo e($home->remark); ?></td>

                            <td>

                                <form method="POST" action="<?php echo route('homes.home.destroy', $home->id); ?>" accept-charset="UTF-8">
                                <input name="_method" value="DELETE" type="hidden">
                                <?php echo e(csrf_field()); ?>


                                    <div class="btn-group btn-group-sm float-right" role="group">
                                        <a href="<?php echo e(route('homes.home.show', $home->id )); ?>" class="btn btn-info" title="แสดงข้อมูล บ้านเลขที่">
                                            <i class=" fas fa-fw fa-eye" aria-hidden="true"></i>
                                        </a>
                                        <a href="<?php echo e(route('homes.home.edit', $home->id )); ?>" class="btn btn-primary" title="แก้ไขข้อมูล บ้านเลขที่">
                                            <i class=" fas fa-fw fa-pencil-alt" aria-hidden="true"></i>
                                        </a>

                                        <button type="submit" class="btn btn-danger" title="ลบ บ้านเลขที่ ทิ้ง" onclick="return confirm('คลิก OK เพื่อยืนยันการลบ บ้านเลขที่ ')">
                                            <i class=" fas fa-fw fa-trash-alt" aria-hidden="true"></i>
                                        </button>
                                    </div>

                                </form>
                                
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

            </div>
        </div>

        <div class="card-footer">
            <?php echo $homes->render(); ?>

        </div>
        
        <?php endif; ?>
    
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp7.4R1\htdocs\disk8\election\source\resources\views/homes/index.blade.php ENDPATH**/ ?>